/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.recipestages.handlers.actions;

import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.recipestages.handlers.actions.base.ActionStageBase;
import com.blamejared.recipestages.recipes.RecipeStage;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.apache.logging.log4j.Logger;

public class ActionSetStageByName
extends ActionStageBase {
    private final ResourceLocation name;

    public ActionSetStageByName(IRecipeManager<CraftingRecipe> manager, String stage, ResourceLocation name) {
        super(manager, stage);
        this.name = name;
    }

    public void apply() {
        ArrayList<Map.Entry<ResourceLocation, CraftingRecipe>> toChange = new ArrayList<Map.Entry<ResourceLocation, CraftingRecipe>>();
        for (Map.Entry entry2 : this.getManager().getRecipes().entrySet()) {
            if (this.name.equals(entry2.getKey())) {
                toChange.add(entry2);
                continue;
            }
            if (!(entry2.getValue() instanceof RecipeStage) || !this.name.equals((Object)((RecipeStage)entry2.getValue()).getRecipe().m_6423_())) continue;
            toChange.add(entry2);
        }
        toChange.forEach(entry -> this.getManager().getRecipes().remove(entry.getKey()));
        this.stageRecipes(toChange);
    }

    public String describe() {
        return "Setting the stage of \"" + Registry.f_122864_.m_7981_((Object)this.getManager().getRecipeType()) + "\" recipes with name: " + this.name + "\" to \"" + this.stage + "\"";
    }

    public boolean validate(Logger logger) {
        boolean containsKey;
        boolean bl = containsKey = this.getManager().getRecipes().containsKey(this.name) || this.getManager().getRecipes().containsKey(new ResourceLocation("recipestages", this.name.toString().replaceAll(":", "_")));
        if (!containsKey) {
            logger.warn("No recipe with type: \"" + Registry.f_122864_.m_7981_((Object)this.getManager().getRecipeType()) + "\" and name: \"" + this.name + "\"");
        }
        return containsKey;
    }
}

